# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_jay_global_optspecs
	string join \n log-level= h/help
end

function __fish_jay_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_jay_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_jay_using_subcommand
	set -l cmd (__fish_jay_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c jay -n "__fish_jay_needs_command" -l log-level -d 'The log level' -r -f -a "trace\t''
debug\t''
info\t''
warn\t''
error\t''"
complete -c jay -n "__fish_jay_needs_command" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_needs_command" -f -a "run" -d 'Run the compositor'
complete -c jay -n "__fish_jay_needs_command" -f -a "generate-completion" -d 'Generate shell completion scripts for jay'
complete -c jay -n "__fish_jay_needs_command" -f -a "log" -d 'Open the log file'
complete -c jay -n "__fish_jay_needs_command" -f -a "set-log-level" -d 'Sets the log level'
complete -c jay -n "__fish_jay_needs_command" -f -a "quit" -d 'Stop the compositor'
complete -c jay -n "__fish_jay_needs_command" -f -a "unlock" -d 'Unlocks the compositor'
complete -c jay -n "__fish_jay_needs_command" -f -a "screenshot" -d 'Take a screenshot'
complete -c jay -n "__fish_jay_needs_command" -f -a "idle" -d 'Inspect/modify the idle (screensaver) settings'
complete -c jay -n "__fish_jay_needs_command" -f -a "run-privileged" -d 'Run a privileged program'
complete -c jay -n "__fish_jay_needs_command" -f -a "seat-test" -d 'Tests the events produced by a seat'
complete -c jay -n "__fish_jay_needs_command" -f -a "portal" -d 'Run the desktop portal'
complete -c jay -n "__fish_jay_needs_command" -f -a "randr" -d 'Inspect/modify graphics card and connector settings'
complete -c jay -n "__fish_jay_needs_command" -f -a "input" -d 'Inspect/modify input settings'
complete -c jay -n "__fish_jay_needs_command" -f -a "damage-tracking" -d 'Modify damage tracking settings. (Only for debugging.)'
complete -c jay -n "__fish_jay_needs_command" -f -a "xwayland" -d 'Inspect/modify xwayland settings'
complete -c jay -n "__fish_jay_needs_command" -f -a "color-management" -d 'Inspect/modify the color-management settings'
complete -c jay -n "__fish_jay_needs_command" -f -a "reexec" -d 'Replace the compositor by another process. (Only for development.)'
complete -c jay -n "__fish_jay_needs_command" -f -a "clients" -d 'Inspect/manipulate the connected clients'
complete -c jay -n "__fish_jay_needs_command" -f -a "tree" -d 'Inspect the surface tree'
complete -c jay -n "__fish_jay_needs_command" -f -a "version" -d 'Prints the Jay version and exits'
complete -c jay -n "__fish_jay_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand run" -l backends -d 'The backends to try' -r -f -a "x11\t''
metal\t''"
complete -c jay -n "__fish_jay_using_subcommand run" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand generate-completion" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand log" -l path -d 'Print the path of the log file'
complete -c jay -n "__fish_jay_using_subcommand log" -s f -l follow -d 'Follow the log'
complete -c jay -n "__fish_jay_using_subcommand log" -s e -l pager-end -d 'Immediately jump to the end in the pager'
complete -c jay -n "__fish_jay_using_subcommand log" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand set-log-level" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand quit" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand unlock" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand screenshot" -l format -d 'The format to use for the image' -r -f -a "png\t'The PNG image format'
qoi\t'The QOI image format'"
complete -c jay -n "__fish_jay_using_subcommand screenshot" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand idle; and not __fish_seen_subcommand_from status set set-grace-period help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand idle; and not __fish_seen_subcommand_from status set set-grace-period help" -f -a "status" -d 'Print the idle status'
complete -c jay -n "__fish_jay_using_subcommand idle; and not __fish_seen_subcommand_from status set set-grace-period help" -f -a "set" -d 'Set the idle interval'
complete -c jay -n "__fish_jay_using_subcommand idle; and not __fish_seen_subcommand_from status set set-grace-period help" -f -a "set-grace-period" -d 'Set the idle grace period'
complete -c jay -n "__fish_jay_using_subcommand idle; and not __fish_seen_subcommand_from status set set-grace-period help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand idle; and __fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand idle; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand idle; and __fish_seen_subcommand_from set-grace-period" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand idle; and __fish_seen_subcommand_from help" -f -a "status" -d 'Print the idle status'
complete -c jay -n "__fish_jay_using_subcommand idle; and __fish_seen_subcommand_from help" -f -a "set" -d 'Set the idle interval'
complete -c jay -n "__fish_jay_using_subcommand idle; and __fish_seen_subcommand_from help" -f -a "set-grace-period" -d 'Set the idle grace period'
complete -c jay -n "__fish_jay_using_subcommand idle; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand run-privileged" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand seat-test" -s a -l all -d 'Test all seats'
complete -c jay -n "__fish_jay_using_subcommand seat-test" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand portal" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand randr; and not __fish_seen_subcommand_from show card output help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand randr; and not __fish_seen_subcommand_from show card output help" -f -a "show" -d 'Show the current settings'
complete -c jay -n "__fish_jay_using_subcommand randr; and not __fish_seen_subcommand_from show card output help" -f -a "card" -d 'Modify the settings of a graphics card'
complete -c jay -n "__fish_jay_using_subcommand randr; and not __fish_seen_subcommand_from show card output help" -f -a "output" -d 'Modify the settings of an output'
complete -c jay -n "__fish_jay_using_subcommand randr; and not __fish_seen_subcommand_from show card output help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from show" -l modes -d 'Show all available modes'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from show" -l formats -d 'Show all available formats'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from card" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from card" -a "primary" -d 'Make this device the primary device'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from card" -a "api" -d 'Modify the graphics API used by the card'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from card" -a "direct-scanout" -d 'Modify the direct scanout setting of the card'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from card" -a "timing" -d 'Modify timing settings of the card'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from card" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "transform" -d 'Modify the transform of the output'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "scale" -d 'Modify the scale of the output'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "mode" -d 'Modify the mode of the output'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "position" -d 'Modify the position of the output'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "enable" -d 'Enable the output'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "disable" -d 'Disable the output'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "non-desktop" -d 'Override the display\'s non-desktop setting'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "vrr" -d 'Change VRR settings'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "tearing" -d 'Change tearing settings'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "format" -d 'Change format settings'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "colors" -d 'Change color settings'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "brightness" -d 'Change the output brightness'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "blend-space" -d 'Change the blend space'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from output" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from help" -f -a "show" -d 'Show the current settings'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from help" -f -a "card" -d 'Modify the settings of a graphics card'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from help" -f -a "output" -d 'Modify the settings of an output'
complete -c jay -n "__fish_jay_using_subcommand randr; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand input; and not __fish_seen_subcommand_from show seat device help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand input; and not __fish_seen_subcommand_from show seat device help" -f -a "show" -d 'Show the current settings'
complete -c jay -n "__fish_jay_using_subcommand input; and not __fish_seen_subcommand_from show seat device help" -f -a "seat" -d 'Modify the settings of a seat'
complete -c jay -n "__fish_jay_using_subcommand input; and not __fish_seen_subcommand_from show seat device help" -f -a "device" -d 'Modify the settings of a device'
complete -c jay -n "__fish_jay_using_subcommand input; and not __fish_seen_subcommand_from show seat device help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from show" -s v -l verbose -d 'Print more information about devices'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "show" -d 'Show information about this seat'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "set-repeat-rate" -d 'Set the repeat rate of the keyboard'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "set-keymap" -d 'Set the keymap'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "keymap" -d 'Retrieve the keymap'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "use-hardware-cursor" -d 'Configure whether this seat uses the hardware cursor'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "set-cursor-size" -d 'Set the size of the cursor'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "simple-im" -d 'Configure the simple, XCompose based input method'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from seat" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "show" -d 'Show information about this device'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-accel-profile" -d 'Set the acceleration profile'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-accel-speed" -d 'Set the acceleration speed'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-tap-enabled" -d 'Set whether tap is enabled'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-tap-drag-enabled" -d 'Set whether tap-drag is enabled'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-tap-drag-lock-enabled" -d 'Set whether tap-drag-lock is enabled'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-left-handed" -d 'Set whether the device is left-handed'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-natural-scrolling" -d 'Set whether the device uses natural scrolling'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-px-per-wheel-scroll" -d 'Set the pixels to scroll per scroll-wheel dedent'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-transform-matrix" -d 'Set the transformation matrix'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-keymap" -d 'Set the keymap of this device'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "keymap" -d 'Retrieve the keymap of this device'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "attach" -d 'Attach the device to a seat'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "detach" -d 'Detach the device from its seat'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "map-to-output" -d 'Maps this device to an output'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "remove-mapping" -d 'Removes the mapping from this device to an output'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-calibration-matrix" -d 'Set the calibration matrix'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-click-method" -d 'Set the click method'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "set-middle-button-emulation" -d 'Set whether the device uses middle button emulation'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from device" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from help" -f -a "show" -d 'Show the current settings'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from help" -f -a "seat" -d 'Modify the settings of a seat'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from help" -f -a "device" -d 'Modify the settings of a device'
complete -c jay -n "__fish_jay_using_subcommand input; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and not __fish_seen_subcommand_from show hide set-color set-decay help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and not __fish_seen_subcommand_from show hide set-color set-decay help" -f -a "show" -d 'Visualize damage'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and not __fish_seen_subcommand_from show hide set-color set-decay help" -f -a "hide" -d 'Hide damage'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and not __fish_seen_subcommand_from show hide set-color set-decay help" -f -a "set-color" -d 'Set the color used for damage visualization'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and not __fish_seen_subcommand_from show hide set-color set-decay help" -f -a "set-decay" -d 'Set the amount of time damage is shown'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and not __fish_seen_subcommand_from show hide set-color set-decay help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from hide" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from set-color" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from set-decay" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from help" -f -a "show" -d 'Visualize damage'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from help" -f -a "hide" -d 'Hide damage'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from help" -f -a "set-color" -d 'Set the color used for damage visualization'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from help" -f -a "set-decay" -d 'Set the amount of time damage is shown'
complete -c jay -n "__fish_jay_using_subcommand damage-tracking; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and not __fish_seen_subcommand_from status set-scaling-mode help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and not __fish_seen_subcommand_from status set-scaling-mode help" -f -a "status" -d 'Print the Xwayland status'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and not __fish_seen_subcommand_from status set-scaling-mode help" -f -a "set-scaling-mode" -d 'Set the Xwayland scaling mode'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and not __fish_seen_subcommand_from status set-scaling-mode help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and __fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and __fish_seen_subcommand_from set-scaling-mode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and __fish_seen_subcommand_from help" -f -a "status" -d 'Print the Xwayland status'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and __fish_seen_subcommand_from help" -f -a "set-scaling-mode" -d 'Set the Xwayland scaling mode'
complete -c jay -n "__fish_jay_using_subcommand xwayland; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand color-management; and not __fish_seen_subcommand_from status enable disable help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand color-management; and not __fish_seen_subcommand_from status enable disable help" -f -a "status" -d 'Print the color-management status'
complete -c jay -n "__fish_jay_using_subcommand color-management; and not __fish_seen_subcommand_from status enable disable help" -f -a "enable" -d 'Enable the color-management protocol'
complete -c jay -n "__fish_jay_using_subcommand color-management; and not __fish_seen_subcommand_from status enable disable help" -f -a "disable" -d 'Disable the color-management protocol'
complete -c jay -n "__fish_jay_using_subcommand color-management; and not __fish_seen_subcommand_from status enable disable help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand color-management; and __fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand color-management; and __fish_seen_subcommand_from enable" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand color-management; and __fish_seen_subcommand_from disable" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand color-management; and __fish_seen_subcommand_from help" -f -a "status" -d 'Print the color-management status'
complete -c jay -n "__fish_jay_using_subcommand color-management; and __fish_seen_subcommand_from help" -f -a "enable" -d 'Enable the color-management protocol'
complete -c jay -n "__fish_jay_using_subcommand color-management; and __fish_seen_subcommand_from help" -f -a "disable" -d 'Disable the color-management protocol'
complete -c jay -n "__fish_jay_using_subcommand color-management; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand reexec" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c jay -n "__fish_jay_using_subcommand clients; and not __fish_seen_subcommand_from show kill help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand clients; and not __fish_seen_subcommand_from show kill help" -f -a "show" -d 'Show information about clients'
complete -c jay -n "__fish_jay_using_subcommand clients; and not __fish_seen_subcommand_from show kill help" -f -a "kill" -d 'Disconnect a client'
complete -c jay -n "__fish_jay_using_subcommand clients; and not __fish_seen_subcommand_from show kill help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from show" -f -a "all" -d 'Show all clients'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from show" -f -a "id" -d 'Show a client with a given ID'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from show" -f -a "select-window" -d 'Interactively select a window and show information about its client'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from show" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from kill" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from kill" -f -a "id" -d 'Kill the client with a given ID'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from kill" -f -a "select-window" -d 'Interactively select a window and kill its client'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from kill" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from help" -f -a "show" -d 'Show information about clients'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from help" -f -a "kill" -d 'Disconnect a client'
complete -c jay -n "__fish_jay_using_subcommand clients; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand tree; and not __fish_seen_subcommand_from query help" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand tree; and not __fish_seen_subcommand_from query help" -f -a "query" -d 'Query the tree'
complete -c jay -n "__fish_jay_using_subcommand tree; and not __fish_seen_subcommand_from query help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -s r -l recursive -d 'Whether to perform a recursive query'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -l all-clients -d 'Whether to repeatedly print details of the same client'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -f -a "root" -d 'Query the entire display'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -f -a "workspace-name" -d 'Query a workspace by name'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -f -a "select-workspace" -d 'Interactively select a workspace to query'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -f -a "select-window" -d 'Interactively select a window to query'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from query" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from help" -f -a "query" -d 'Query the tree'
complete -c jay -n "__fish_jay_using_subcommand tree; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand version" -s h -l help -d 'Print help'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "run" -d 'Run the compositor'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "generate-completion" -d 'Generate shell completion scripts for jay'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "log" -d 'Open the log file'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "set-log-level" -d 'Sets the log level'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "quit" -d 'Stop the compositor'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "unlock" -d 'Unlocks the compositor'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "screenshot" -d 'Take a screenshot'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "idle" -d 'Inspect/modify the idle (screensaver) settings'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "run-privileged" -d 'Run a privileged program'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "seat-test" -d 'Tests the events produced by a seat'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "portal" -d 'Run the desktop portal'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "randr" -d 'Inspect/modify graphics card and connector settings'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "input" -d 'Inspect/modify input settings'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "damage-tracking" -d 'Modify damage tracking settings. (Only for debugging.)'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "xwayland" -d 'Inspect/modify xwayland settings'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "color-management" -d 'Inspect/modify the color-management settings'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "reexec" -d 'Replace the compositor by another process. (Only for development.)'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "clients" -d 'Inspect/manipulate the connected clients'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "tree" -d 'Inspect the surface tree'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "version" -d 'Prints the Jay version and exits'
complete -c jay -n "__fish_jay_using_subcommand help; and not __fish_seen_subcommand_from run generate-completion log set-log-level quit unlock screenshot idle run-privileged seat-test portal randr input damage-tracking xwayland color-management reexec clients tree version help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from idle" -f -a "status" -d 'Print the idle status'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from idle" -f -a "set" -d 'Set the idle interval'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from idle" -f -a "set-grace-period" -d 'Set the idle grace period'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from randr" -f -a "show" -d 'Show the current settings'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from randr" -f -a "card" -d 'Modify the settings of a graphics card'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from randr" -f -a "output" -d 'Modify the settings of an output'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from input" -f -a "show" -d 'Show the current settings'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from input" -f -a "seat" -d 'Modify the settings of a seat'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from input" -f -a "device" -d 'Modify the settings of a device'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from damage-tracking" -f -a "show" -d 'Visualize damage'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from damage-tracking" -f -a "hide" -d 'Hide damage'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from damage-tracking" -f -a "set-color" -d 'Set the color used for damage visualization'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from damage-tracking" -f -a "set-decay" -d 'Set the amount of time damage is shown'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from xwayland" -f -a "status" -d 'Print the Xwayland status'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from xwayland" -f -a "set-scaling-mode" -d 'Set the Xwayland scaling mode'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from color-management" -f -a "status" -d 'Print the color-management status'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from color-management" -f -a "enable" -d 'Enable the color-management protocol'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from color-management" -f -a "disable" -d 'Disable the color-management protocol'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from clients" -f -a "show" -d 'Show information about clients'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from clients" -f -a "kill" -d 'Disconnect a client'
complete -c jay -n "__fish_jay_using_subcommand help; and __fish_seen_subcommand_from tree" -f -a "query" -d 'Query the tree'
